@echo off
setlocal ENABLEDELAYEDEXPANSION
title blog2video runner
cd /d "%~dp0"

:: Python 3.11 固定
set "PYCMD=python"

:: バージョン確認
for /f "tokens=2" %%V in ('%PYCMD% --version 2^>^&1') do set "PYVER=%%V"
echo 使用する Python バージョン: %PYVER%
if not "%PYVER:~0,4%"=="3.11" (
    echo [WARN] Python 3.11 以外です。動作しない可能性があります。
)
echo.

:: 依存関係インストール
if exist "requirements.txt" (
    echo requirements.txt を検出しました。必要なライブラリをインストールします...
    "%PYCMD%" -m pip install --upgrade pip
    "%PYCMD%" -m pip install -r requirements.txt
) else (
    echo requirements.txt が無かったため、必要なライブラリを個別インストールします...
    "%PYCMD%" -m pip install --upgrade pip
    "%PYCMD%" -m pip install gTTS moviepy pillow numpy
)
if errorlevel 1 (
    echo [ERROR] 依存関係のインストールに失敗しました。
    goto END
)

:: 出力フォルダ作成
if not exist "output" mkdir "output"
if not exist "temp"   mkdir "temp"

echo.
echo === 実行 ===
"%PYCMD%" "main.py"
if errorlevel 1 (
    echo [ERROR] スクリプト実行でエラーが発生しました。
    goto END
)

echo.
echo === 完了 ===
echo output\final_video.mp4 をご確認ください。

:END
pause
endlocal
